//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CommaExpr.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Mon May 02 15:19:44 2016
// Update Count     : 1
//

#include "Expression.h"
#include "Type.h"
#include "Common/utility.h"

CommaExpr::CommaExpr( Expression *arg1, Expression *arg2, Expression *_aname )
		: Expression( _aname ), arg1( arg1 ), arg2( arg2 ) {
	// xxx - result of a comma expression is never an lvalue, so should set lvalue
	// to false on all result types. Actually doing this causes some strange things
	// to happen in later passes (particularly, Specialize, Lvalue, and Box). This needs to be looked into.
	set_result( maybeClone( arg2->get_result() ) );
	// get_type->set_isLvalue( false );
}

CommaExpr::CommaExpr( const CommaExpr &other )
		: Expression( other ), arg1( maybeClone( other.arg1 ) ), arg2( maybeClone( other.arg2 ) ) {
}

CommaExpr::~CommaExpr() {
	delete arg1;
	delete arg2;
}

void CommaExpr::print( std::ostream &os, int indent ) const {
	os << "Comma Expression:" << std::endl;
	os << std::string( indent+2, ' ' );
	arg1->print( os, indent+2 );
	os << std::endl;
	os << std::string( indent+2, ' ' );
	arg2->print( os, indent+2 );
	Expression::print( os, indent );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
