//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// align.h --
//
// Author           : Thierry Delisle
// Created On       : Mon Feb 12 18:06:59 2018
// Last Modified By :
// Last Modified On :
// Update Count     : 0
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
//
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
//
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
//

#pragma once

extern "C" {
#include <time.h>
}

#include "bits/defs.h"

struct timespec;
struct itimerval;

//=============================================================================================
// time type
//=============================================================================================

struct __cfa_time_t {
	uint64_t val;
};

// ctors
static inline void ?{}( __cfa_time_t & this ) { this.val = 0; }
static inline void ?{}( __cfa_time_t & this, const __cfa_time_t & rhs ) { this.val = rhs.val; }
static inline void ?{}( __cfa_time_t & this, zero_t zero ) { this.val = 0; }

static inline __cfa_time_t ?=?( __cfa_time_t & this, zero_t rhs ) {
	this.val = 0;
	return this;
}

// logical ops
static inline bool ?==?( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val == rhs.val; }
static inline bool ?!=?( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val != rhs.val; }
static inline bool ?>? ( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val >  rhs.val; }
static inline bool ?<? ( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val <  rhs.val; }
static inline bool ?>=?( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val >= rhs.val; }
static inline bool ?<=?( __cfa_time_t lhs, __cfa_time_t rhs ) { return lhs.val <= rhs.val; }

static inline bool ?==?( __cfa_time_t lhs, zero_t rhs ) { return lhs.val == rhs; }
static inline bool ?!=?( __cfa_time_t lhs, zero_t rhs ) { return lhs.val != rhs; }
static inline bool ?>? ( __cfa_time_t lhs, zero_t rhs ) { return lhs.val >  rhs; }
static inline bool ?<? ( __cfa_time_t lhs, zero_t rhs ) { return lhs.val <  rhs; }
static inline bool ?>=?( __cfa_time_t lhs, zero_t rhs ) { return lhs.val >= rhs; }
static inline bool ?<=?( __cfa_time_t lhs, zero_t rhs ) { return lhs.val <= rhs; }

// addition/substract
static inline __cfa_time_t ?+?( __cfa_time_t lhs, __cfa_time_t rhs ) {
	__cfa_time_t ret;
	ret.val = lhs.val + rhs.val;
	return ret;
}

static inline __cfa_time_t ?-?( __cfa_time_t lhs, __cfa_time_t rhs ) {
	__cfa_time_t ret;
	ret.val = lhs.val - rhs.val;
	return ret;
}

static inline __cfa_time_t ?`cfa_s ( uint64_t val ) { __cfa_time_t ret; ret.val = val * 1_000_000_000ul; return ret; }
static inline __cfa_time_t ?`cfa_ms( uint64_t val ) { __cfa_time_t ret; ret.val = val *     1_000_000ul; return ret; }
static inline __cfa_time_t ?`cfa_us( uint64_t val ) { __cfa_time_t ret; ret.val = val *         1_000ul; return ret; }
static inline __cfa_time_t ?`cfa_ns( uint64_t val ) { __cfa_time_t ret; ret.val = val *             1ul; return ret; }

static inline __cfa_time_t from_s  ( uint64_t val ) { __cfa_time_t ret; ret.val = val * 1_000_000_000ul; return ret; }
static inline __cfa_time_t from_ms ( uint64_t val ) { __cfa_time_t ret; ret.val = val *     1_000_000ul; return ret; }
static inline __cfa_time_t from_us ( uint64_t val ) { __cfa_time_t ret; ret.val = val *         1_000ul; return ret; }
static inline __cfa_time_t from_ns ( uint64_t val ) { __cfa_time_t ret; ret.val = val *             1ul; return ret; }

static inline uint64_t to_s  ( __cfa_time_t t ) { return t.val / 1_000_000_000ul; }
static inline uint64_t to_ms ( __cfa_time_t t ) { return t.val /     1_000_000ul; }
static inline uint64_t to_us ( __cfa_time_t t ) { return t.val /         1_000ul; }
static inline uint64_t to_ns ( __cfa_time_t t ) { return t.val /             1ul; }