//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// prolog.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec 11 23:27:19 2018
// Update Count     : 6
//

#include <fstream.hfa>

void printResult( int x ) { sout | "int"; }
void printResult( double x ) { sout | "double"; }
void printResult( char * x ) { sout | "char*"; }

void is_arithmetic( int x ) {}
void is_arithmetic( double x ) {}

void is_integer( int x ) {}

trait ArithmeticType( otype T ) {
	void is_arithmetic( T );
};

trait IntegralType( otype T | ArithmeticType( T ) ) {
	void is_integer( T );
};

forall( otype T | IntegralType( T ) | { void printResult( T ); } )
void hornclause( T param ) {
	printResult( param );
}

int main() {
	int x;
	double x;
	char * x;
	hornclause( x );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa prolog.c" //
// End: //
