//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// twice.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec 11 23:28:08 2018
// Update Count     : 47
//

#include <fstream.hfa>

forall( otype T | { T ?+?( T, T ); } )
T twice( const T t ) {
	return t + t;
}

// char does not have addition
char ?+?( char op1, char op2 ) { return (int)op1 + op2; } // cast forces integer addition or recursion

// signed char does not have addition
signed char ?+?( signed char op1, signed char op2 ) { return (int)op1 + op2; } // cast forces integer addition or recursion

int main( void ) {
	sout | twice( ' ' ) | ' ' | twice( (signed char)0 ) | twice( (int)1 ) | twice( 3.2 );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa twice.c" //
// End: //
