//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Constant.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jun 30 13:33:17 2016
// Update Count     : 6
//

#ifndef CONSTANT_H
#define CONSTANT_H

#include "SynTree.h"
#include "Visitor.h"
#include "Mutator.h"

class Constant {
  public:
	Constant( Type *type, std::string value );
	Constant( const Constant &other );
	virtual ~Constant();

	Type *get_type() { return type; }
	void set_type( Type *newValue ) { type = newValue; }
	std::string &get_value() { return value; }
	void set_value( std::string newValue ) { value = newValue; }

	/// generates an integer constant of the given int
	static Constant from_int( int i );
	/// generates an integer constant of the given unsigned long int
	static Constant from_ulong( unsigned long i );
	/// generates a floating point constant of the given double
	static Constant from_double( double d );

	virtual Constant *clone() const;
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Constant *acceptMutator( Mutator &m ) { return m.mutate( this ); }
	virtual void print( std::ostream &os ) const;
  private:
	Type *type;
	std::string value;
};

#endif // CONSTANT_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
