#include <stdlib.h>
#include "c-pair.h"

pair * new_pair( void * first, void * second ) {
	pair * p = malloc( sizeof(pair) ); /***/
	*p = (pair){ first, second }; /***/
	return p;
}

pair * copy_pair( const pair * src, 
		void * (* copy_first)(const void* ), void * (* copy_second)(const void *)) {
	return new_pair( copy_first(src->first), copy_second(src->second) );
}

void free_pair( pair * p, void (* free_first)(void *), void (* free_second)(void *)) {
	free_first( p->first );
	free_second( p->second );
	free( p );
}

int cmp_pair( const pair * a, const pair * b, 
		int (* cmp_first)(const void *, const void *), int (* cmp_second)(const void *, const void *)) {
	int c = cmp_first( a->first, b->first );
	if ( c == 0 ) c = cmp_second( a->second, b->second );
	return c;
}
