#pragma once

#include <fstream>
#include <stddef.h>
#include <stdlib>

//==============================================================================
// type safe malloc / free

forall(otype T)
T* new()
{
	T* p = malloc();
	p{};
	return p;
}

forall(otype T)
void delete(T* p)
{
	^p{};
	free(p);
}

//==============================================================================
// ref counter content

struct content_t
{
	int value;
	size_t count;
};

void ?{}(content_t* this)
{
	sout | "Constructing content" | endl;
	this->count = 0;
}

void ?{}(content_t* this)
{
	sout | "Constructing content" | endl;
	this->count = 0;
}

void ^?{}(content_t* this)
{
	sout | "Destroying content" | endl;
}

//==============================================================================
// ref counter wrapper

struct wrapper_t
{
	content_t* ptr;
};

wrapper_t wrap(int val)
{
	wrapper_t w;
	content_t* c = malloc;
	c{};
	c->value = val;
	reset(&w, c);
	return w;
}

void ?{}(wrapper_t* this)
{
	this->ptr = new();
	this->ptr->count++;
	sout | "Constructing empty ref pointer" | endl;
}

void ^?{}(wrapper_t* this)
{
	{
		this->ptr->count--;
		if(!this->ptr->count) delete(this->ptr);
		sout | "Destroying ref pointer" | endl;
		sout | "Reference is " | this->ptr->count | endl;
	}
	else
	{
		sout | "Destroying empty ref pointer" | endl;
	}
}

void set(wrapper_t* this, content_t* c)
{
	this->ptr = c;
	sout | "Setting ref pointer" | endl;
	sout | "Reference is " | this->ptr->count | endl;
}
