#!/usr/bin/python3

"""
Python Script to convert output from trun to rmit like output
"""
import argparse
import json
import locale
import os
import re
import sys

locale.setlocale( locale.LC_ALL, 'en_US.UTF-8' )

parser = argparse.ArgumentParser(description='Python Script to convert output from trun to rmit like output')
parser.add_argument('--out', nargs='?', type=argparse.FileType('w'), default=sys.stdout)
parser.add_argument('files', nargs='+')
options =  parser.parse_args()

def extract(file):
	raw = []
	with open(file, "r") as f:
		for line in f:
			if line.startswith("Combined"):
				break

		h = next(f)
		next(f)

		columns = h.strip().split()
		if not len(columns) == 20:
			print("{}: Failed to split header row '{}', unexpected number of columns.".format(file, h), file=sys.stderr)
			raise ValueError

		for line in f:
			line = line.strip()
			if not line:
				break

			raw.append(line)

	results = []
	for l in raw:
		vals = l.split()
		if not len(vals) == 21:
			print("{}: Failed to split result row '{}', unexpected number of columns ({}).".format(file, l, len(vals)), file=sys.stderr)
			raise ValueError
		d = {
			'Request Rate': float(vals[0]),
			'MinReplies':   float(vals[1]),
			'MeanReplies':  float(vals[2]),
			'MaxReplies':   float(vals[3]),
			'StdReplies':   float(vals[4]),
			'Conn':         float(vals[5]),
			'Resp':         float(vals[6]),
			'Xfer':         float(vals[7]),
			'Total':        float(vals[8]),
			'Std':          float(vals[9]),
			'Med':          float(vals[10]),
			'Min':          float(vals[11]),
			'Max':          float(vals[12]),
			'Data Rate':    float(vals[13]),
			'Errors':       float(vals[14]),
			'Reqs':         float(vals[15]),
			'ActRateC':     float(vals[16]),
			'ActRate':      float(vals[17]),
			'Error Rate':   float(vals[18]),
			'SamplesT':     float(vals[19]),
			'SamplesR':     float(vals[20])
		}
		results.append(d)

	return results




data = []

print(options.files)

for file in options.files:
	# checking if it is a file
	if os.path.isfile(file):
		filename = os.path.basename(file)
		match = re.search("swbsrv\.([0-9]+)gb\.(cfa|nginx)", filename)
		try:
			series = match[2]
			memory = match[1]
		except:
			print("Can't parse filename '{}' from File '{}'.".format(filename, file), file=sys.stderr)
			continue

		try:
			results = extract(file)
		except OSError:
			print("Cannot open File '{}'.".format(file), file=sys.stderr)
			continue
		except ValueError:
			continue

		for result in results:
			d = [series, memory, result]
			data.append(d)

	else:
		print("File '{}' does not exist.".format(file), file=sys.stderr)

options.out.write(json.dumps(data))
options.out.flush()
options.out.write("\n")