import java.io.*;

public class testP1 {
    public enum Planet {
		//          mass      radius
		MERCURY ( 3.303E23, 2.4397E6 ),
		VENUS   ( 4.869E24, 6.0518E6 ),
		EARTH   ( 5.976E24, 6.37814E6 ),
		MARS    ( 6.421E23, 3.3972E6 ),
		JUPITER ( 1.9E27,   7.1492E7 ),
		SATURN  ( 5.688E26, 6.0268E7 ),
		URANUS  ( 8.686E25, 2.5559E7 ),
		NEPTUNE ( 1.024E26, 2.4746E7 );

		private final double mass;   // in kilograms
		private final double radius; // in meters

		Planet( double mass, double radius ) {
			this.mass = mass;
			this.radius = radius;
		}
		private double mass() { return mass; }
		private double radius() { return radius; }

		// universal gravitational constant  (m3 kg-1 s-2)
		public static final double G = 6.67300E-11;

		double surfaceGravity() {
			return G * mass / ( radius * radius );
		}
		double surfaceWeight( double otherMass ) {
			return otherMass * surfaceGravity();
		}
    }
    public static void main( String[] args ) {
		if ( args.length != 1 ) {
			System.err.println( "Usage: java Planet <earth_weight>" );
			System.exit( -1 );
		}
		double earthWeight = Double.parseDouble( args[0] );
		double mass = earthWeight / Planet.EARTH.surfaceGravity();
		for ( Planet p : Planet.values() )
			System.out.printf( "Your weight on %s is %f%n", p, p.surfaceWeight( mass ) );
    }
}

// java test
