import java.io.*;

public class test {
	enum Week {
		Mon, Tue, Wed, Thu, Fri, Sat, Sun;
		public boolean isWeekday() { return ordinal() <= Fri.ordinal(); }
		public boolean isWeekend() { return Fri.ordinal() < ordinal(); }
	}
	

	// object oriented definition
	enum Week2 {
		//	    Mon, Tue, Wed, Thu, Fri, Sat, Sun;
		Mon(1), Tue(2), Wed(3), Thu(4), Fri(5), Sat(6), Sun(7); // must appear first
		public long day;
		private Week2( long d ) { day = d; }

		public boolean isWeek() {
			return ordinal() <= Week2.Fri.ordinal();
		}
		public boolean isWeekend() {
			return Week2.Fri.ordinal() < ordinal();
		}
	}

	public static void main( String[] args ) {
		// non-object oriented usage
		Week day = Week.Sat;
		
		day = Week.valueOf( "Sat" );
		System.out.println( day.ordinal() + " " + day + " " + day.name() ); // 5 Sat
		System.out.println( day.isWeekday() );  // false
		System.out.println( day.isWeekend() );  // true

		if ( day == Week.Fri )
			System.out.println( "weekday" );
		switch ( day ) {
		  case Mon: case Tue: case Wed: case Thu: case Fri:
			System.out.println( "weekday" );
			break;
		  case Sat: case Sun:
			System.out.println( "weekend" );
			break;
		}
		for ( Week d : Week.values() ) {
			System.out.print( d + " " + d.ordinal() + " " );
		}
		System.out.println(); System.out.println();

		// object oriented usage
		Week2 cday = Week2.Sat;
		cday.day += 42;
		System.out.println( cday.ordinal() + " " + cday.day + " " +  cday.name() );

		System.out.println( cday.isWeek() );  // false
		System.out.println( cday.isWeekend() );  // true

		switch ( cday ) {
		  case Mon: case Tue: case Wed: case Thu: case Fri:
			System.out.println( "weekday" );
			break;
		  case Sat: case Sun:
			System.out.println( "weekend" );
			break;
		}
		for ( Week2 icday : Week2.values() ) {
			System.out.print( icday.ordinal() + " " + icday.day + " " +  icday.name() + ",  " );
		}
		System.out.println();

		int intArray[];
		intArray = new int[20];
		intArray[Week.Fri] = 3;
	}
}

// java test
