with Ada.Text_IO; use Ada.Text_IO;
-- with Ada.Standard; use Ada.Standard;
procedure test is
	type RGB is ( Red, Green, Blue );
	for RGB use ( Red => 10, Green => 20, Blue => 30 );
	Colour : RGB := Red;
	
	type ABC is ('A', 'B', 'C');
	Chars : ABC := 'C';
	
	type Operator is ( '+', '-', '*', '/' );
	for Operator use ( '+' => 10, '-' => 20, '*' => 30, '/' => 40 );
	op : Operator := '+';
	Ops : array( 0..3) of Operator;
	
	type Week is ( Mon, Tue, Wed, Thu, Fri, Sat, Sun );
	for Week use ( Mon => 0, Tue => 1, Wed => 2, Thu => 10, Fri => 11, Sat => 14, Sun => 15 );
	subtype Weekday is Week range Mon .. Fri;
	subtype Weekend is Week range Sat .. Sun;
	Day : Week;
	Lunch : array( Week ) of Integer;
	
--   type Boolean is ( False, True );
	B : Boolean := True;
begin
	Put_Line( Integer'Image( RGB'Pos( Colour ) ) & " " & RGB'Image( RGB'Val(0) ) );
	Put_Line( Integer'Image( RGB'Enum_Rep( Colour ) ) & " " & RGB'Image( RGB'Enum_Val( 10 ) ) );
	Put_Line( """" & RGB'Image( Colour ) & """ " & RGB'Image( RGB'Value( "Red" ) ) );

	
	Put_Line( RGB'Image( Colour ) & Integer'Image( RGB'Pos( Colour ) ) & Integer'Image( RGB'Enum_Rep( Colour ) ) );
	Put_Line( RGB'Image( Colour ) & Integer'Image( RGB'Pos( Colour ) ) & Integer'Image( RGB'Enum_Rep( Colour ) ) );
	
	for op in RGB loop
		Put( "(" & Integer'Image( RGB'Pos( op ) ) & Integer'Image( RGB'Enum_Rep( op ) ) & ' ' & RGB'Image( op ) & ") " );
	end loop;
	Put_Line( "" );

	Put_Line( ABC'Image( Chars ) );
	Put_Line( Integer'Image( ABC'Pos( Chars ) ) );
	
	Op := '+';
	if Op = '+' or else Op = '-' then null;
	elsif Op = '*' or else Op = '/' then null; end if;
	
	case Op is
		when '+' => null;
		when '-' => null;
		when '*' => null;
--      when '/' => null;
		when others => null;
	end case;
	for op in Operator loop
		Put( "(" & Integer'Image( Operator'Pos( op ) ) & Integer'Image( Operator'Enum_Rep( op ) ) & ' ' & Operator'Image( op ) & ") " );
	end loop;
	Put_Line( "" );
	
	Ops := "+-*/";
	Ops := "+-" & "*/";
	for Op of Ops loop
		Put_Line( Operator'Image( Op ) );
	end loop;
	Day := Wed;
	case Day is
		when Mon .. Fri => null;
		when Sat .. Sun => null;
	end case;
	case Day is
		when Weekday => null;
		when Weekend => null;
	end case;
	for Day in Mon .. Sun loop
		Put( Week'Image( Day ) & " " );
	end loop;
	Put_Line( "" );
	for Day in Week loop
		Put( Week'Image( Day ) & " " );
	end loop;
	Put_Line( "" );
	for Day in Weekday loop
		Put( Week'Image( Day ) & " " );
	end loop;
	Put_Line( "" );
	for Day in Weekend loop
		Put( Week'Image( Day ) & " " );
	end loop;
	Put_Line( "" );
	
	for Day in Week loop
		Lunch( Day ) := 3;
	end loop;
	for Day in Week loop
		Put( Integer'Image( Lunch(Day ) ) & " " );
	end loop;
	
	if B then null; end if;
end test;

-- Local Variables: --
-- tab-width: 4 --
-- compile-command: "gnatmake test.adb" --
-- End: --
