import java.io.*;

public class testP2 {
	public enum Planet {
		//          mass      radius
		MERCURY ( 3.303e+23, 2.4397e6 ),
		VENUS   ( 4.869e+24, 6.0518e6 ),
		EARTH   ( 5.976e+24, 6.37814e6 ),
		MARS    ( 6.421e+23, 3.3972e6 ),
		JUPITER ( 1.9e+27,   7.1492e7 ),
		SATURN  ( 5.688e+26, 6.0268e7 ),
		URANUS  ( 8.686e+25, 2.5559e7 ),
		NEPTUNE ( 1.024e+26, 2.4746e7 );

		private final double mass;   // in kilograms
		public final double radius; // in meters

		Planet( double mass, double radius ) {
			this.mass = mass; this.radius = radius;
		}
	}
	static double mass( Planet p ) { return p.mass; }
	static double radius( Planet p ) { return p.radius; }

	static double surfaceGravity( Planet p ) {
		return 6.67300E-11 * p.mass / ( p.radius * p.radius );
	}
	static double surfaceWeight( Planet p, double otherMass ) {
		return otherMass * surfaceGravity( p );
	}
	public static void main( String[] args ) {
		if ( args.length != 1 ) {
			System.err.println( "Usage: java Planet <earth_weight>" );
			System.exit( -1 );
		}
		Planet day = Planet.valueOf( "EARTH" );
		System.out.println( day.ordinal() + " " + day.name() + " " + day.mass + " " + day.radius + " " + Planet.valueOf( "EARTH" ) ); // 5 Sat

		double earthWeight = Double.parseDouble( args[0] );
		double mass = earthWeight / surfaceGravity( Planet.EARTH );
		for ( Planet p : Planet.values() )
			System.out.printf( "Your weight on %s is %f%n", p, surfaceWeight( p, mass ) );
	}
}

// java test
