use std::mem;

#[repr(u8)] enum Fieldless {
    Tuple() = 5,
    Struct{} = 10,
    Unit = 12,
}
impl Fieldless {
    fn discriminant(&self) -> u8 {
        // SAFETY: Because `Self` is marked `repr(u8)`, its layout is a `repr(C)` `union`
        // between `repr(C)` structs, each of which has the `u8` discriminant as its first
        // field, so we can read the discriminant without offsetting the pointer.
        unsafe { *<*const _>::from(self).cast::<u8>() }
    }
}
fn main() {
	let mut fl : Fieldless;
	fl = Fieldless::Struct{};
	match fl {
		Fieldless::Struct{} => println!( "Struct" ),
		_ => (),
	}
	if mem::discriminant(&fl) == mem::discriminant(&Fieldless::Struct{}) {
		println!( "Struct" );
	}
	if fl.discriminant() == 10 {
		println!( "Struct" );
	}
}

// Local Variables: //
// tab-width: 4 //
// End: //
