#include "object_header.h"

#include <stdint.h>

#include "globals.h"
#include "gcpointers.h"

void ctor(gc_object_header* const this, size_t inSize)
{
	#if _DEBUG
		this->canary_start = CANARY_VALUE;
	#endif

	this->size = inSize;
	this->root_chain = NULL;
	this->type_chain = NULL;
	this->forward = NULL;
	this->is_forwarded = false;

	#if _DEBUG
		this->canary_end = CANARY_VALUE;
	#endif
}

void copy_ctor(gc_object_header* const this, const gc_object_header* const other)
{
	#if _DEBUG
		this->canary_start = CANARY_VALUE;
	#endif

	this->size = other->size;
	this->root_chain = other->root_chain;
	this->type_chain = NULL;
	this->forward = NULL;
	this->is_forwarded = false;

	#if _DEBUG
		this->canary_end = CANARY_VALUE;
	#endif

	gcpointer_t* root = this->root_chain;
	while(root)
	{
		check(get_object_ptr(root->ptr) == other);
		root->ptr = ((intptr_t)this) + sizeof(gc_object_header);

		check(get_object_ptr(root->ptr) == this);
		root = root->next;
	}

	gcpointer_t* type = other->type_chain;

	while(type)
	{
		check((intptr_t)type < (intptr_t)((intptr_t)other + other->size));

		size_t offset = (intptr_t)type - (intptr_t)other;
		check(offset < size);

		gcpointer_t* member_ptr = (gcpointer_t*)( (intptr_t)this + offset );

		if(!this->type_chain) this->type_chain = member_ptr;

		size_t next_offset = type->next ? (intptr_t)type->next - (intptr_t)other : 0;
		check(next_offset < size);

		gcpointer_t* next_ptr = type->next ? (gcpointer_t*)((intptr_t)this + next_offset) : NULL;

		member_ptr->ptr = type->ptr;
		member_ptr->next = next_ptr;

		type = type->next;
	}

	check(is_valide(this));
}

#if _DEBUG
	bool is_valide(const gc_object_header* const this)
	{
		check(this->canary_start == CANARY_VALUE);
		check(this->canary_end == CANARY_VALUE);

		check(this->is_forwarded == (this->forward != nullptr));

		check(this->size < POOL_SIZE_BYTES);

		gcpointer_t* root = this->root_chain;
		while(root)
		{
			check(get_object_ptr(root->ptr) == this);

			root = root->next;
		}

		gcpointer_t* type = type_chain;
		while(type)
		{
			check((intptr_t)type > (intptr_t)this);
			check((intptr_t)type < (intptr_t)((intptr_t)this + size));

			type = type->next;
		}

		return true;
	}
#endif
