// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// fmtLines.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sun Sep 17 21:56:15 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec  5 21:56:35 2017
// Update Count     : 38
// 

#include <fstream>
#include <coroutine>

coroutine Format {
	char ch;											// used for communication
	int g, b;											// global because used in destructor
};

void ?{}( Format & fmt ) {
	resume( fmt );										// prime (start) coroutine
}

void ^?{}( Format & fmt ) with( fmt ) {
	if ( g != 0 || b != 0 ) sout | endl;
}

void main( Format & fmt ) with( fmt ) {
	for ( ;; ) {										// for as many characters
		for ( g = 0; g < 5; g += 1 ) {					// groups of 5 blocks
			for ( b = 0; b < 4; b += 1 ) {				// blocks of 4 characters
				for ( ;; ) {							// for newline characters
					suspend();
					if ( ch != '\n' ) break;			// ignore newline
				} // for
				sout | ch;								// print character
			} // for
			sout | "  ";								// print block separator
		} // for
		sout | endl;									// print group separator
	} // for
} // main

void prt( Format & fmt, char ch ) {
	fmt.ch = ch;
	resume( fmt );
} // prt

int main() {
	Format fmt;											// format characters into blocks of 4 and groups of 5 blocks per line
	char ch;

	Eof: for ( ;; ) {									// read until end of file
		sin | ch;										// read one character
	  if ( eof( sin ) ) break Eof;						// eof ?
		prt( fmt, ch );									// push character for formatting
	} // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa fmtLines.c" //
// End: //
