//                               -*- Mode: C -*-
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// datingService.c --
//
// Author           : Peter A. Buhr
// Created On       : Mon Oct 30 12:56:20 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec  5 23:06:40 2017
// Update Count     : 18
//

#include <stdlib>										// random
#include <fstream>
#include <kernel>
#include <thread>
#include <unistd.h>										// getpid

enum { NoOfPairs = 20 };

monitor DatingService {
	condition Girls[NoOfPairs], Boys[NoOfPairs];
	unsigned int GirlPhoneNo, BoyPhoneNo;
}; // DatingService

unsigned int girl( DatingService & mutex ds, unsigned int PhoneNo, unsigned int ccode ) with( ds ) {
	if ( is_empty( Boys[ccode] ) ) {
		wait( Girls[ccode] );
		GirlPhoneNo = PhoneNo;
	} else {
		GirlPhoneNo = PhoneNo;
		signal_block( Boys[ccode] );
	} // if
	return BoyPhoneNo;
} // DatingService girl

unsigned int boy( DatingService & mutex ds, unsigned int PhoneNo, unsigned int ccode ) with( ds ) {
	if ( is_empty( Girls[ccode] ) ) {
		wait( Boys[ccode] );
		BoyPhoneNo = PhoneNo;
	} else {
		BoyPhoneNo = PhoneNo;
		signal_block( Girls[ccode] );
	} // if
	return GirlPhoneNo;
} // DatingService boy

unsigned int girlck[NoOfPairs];
unsigned int boyck[NoOfPairs];

thread Girl {
	DatingService & TheExchange;
	unsigned int id, ccode;
}; // Girl

void main( Girl & g ) {
	yield( random( 100 ) );								// don't all start at the same time
	unsigned int partner = girl( g.TheExchange, g.id, g.ccode );
	sout | "Girl:" | g.id | "is dating Boy at" | partner | "with ccode" | g.ccode | endl;
	girlck[g.id] = partner;
} // Girl main

void ?{}( Girl & g, DatingService * TheExchange, unsigned int id, unsigned int ccode ) {
	&g.TheExchange = TheExchange;
	g.id = id;
	g.ccode = ccode;
} // Girl ?{}

thread Boy {
	DatingService &TheExchange;
	unsigned int id, ccode;
}; // Boy

void main( Boy & b ) {
	yield( random( 100 ) );								// don't all start at the same time
	unsigned int partner = boy( b.TheExchange, b.id, b.ccode );
	sout | " Boy:" | b.id | "is dating Girl" | partner | "with ccode" | b.ccode | endl;
	boyck[b.id] = partner;
} // Boy main

void ?{}( Boy & b, DatingService * TheExchange, unsigned int id, unsigned int ccode ) {
	&b.TheExchange = TheExchange;
	b.id = id;
	b.ccode = ccode;
} // Boy ?{}

int main() {
	DatingService TheExchange;
	Girl *girls[NoOfPairs];
	Boy  *boys[NoOfPairs];

	random_seed( /*getpid()*/ 103 );

	for ( unsigned int i = 0; i < NoOfPairs; i += 1 ) {
		girls[i] = new( &TheExchange, i, i );
		boys[i]  = new( &TheExchange, i, NoOfPairs - ( i + 1 ) );
	} // for

	for ( unsigned int i = 0; i < NoOfPairs; i += 1 ) {
		delete( boys[i] );
		delete( girls[i] );
	} // for

	for ( unsigned int i = 0; i < NoOfPairs; i += 1 ) {
		if ( girlck[ boyck[i] ] != boyck[ girlck[i] ] ) abort();
	} // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa datingService.c" //
// End: //
