#include "avl.h"
#include "avl-private.h"

extern "C" {
  int strcmp(const char *, const char *);
}

int main(){
  // operations:
  // find(tree(K, V) *, K)
  // int empty(tree(K, V) *);
  // tree(K, V) * insert(tree(K, V) *, K, V);
  // int remove(tree(K, V) **, K);

  // int -> int
  tree(int, int) * imap = create(-1, (int)0);
  insert(&imap, 12, 13);
  insert(&imap, 2, 3);
  assert( height(imap) == 2 );

  printf("%d %d %d\n", *find(imap, 2), *find(imap, 12), *find(imap, -1));

  remove(&imap, -1);
  delete(imap);

  // int -> char *
  tree(int, char *) * smap = create(-1, "baz");
  insert(&smap, 12, "bar");
  insert(&smap, 2, "foo");
  assert( height(smap) == 2 );

  printf("%s %s %s\n", *find(smap, 2), *find(smap, 12), *find(smap, -1));

  remove(&smap, -2);
  delete(smap);

  // char* -> char*
  struct c_str { char *str; };  // wraps a C string
  int ?<?(c_str a, c_str b) {
    return strcmp(a.str,b.str) < 0;
  }
  tree(c_str, char *) * ssmap = create((c_str){"queso"}, "cheese");
  insert(&ssmap, (c_str){"foo"}, "bar");
  insert(&ssmap, (c_str){"hello"}, "world");
  assert( height(ssmap) == 2 );

  printf("%s %s %s\n", *find(ssmap, (c_str){"hello"}), *find(ssmap, (c_str){"foo"}), *find(ssmap, (c_str){"queso"}));

  remove(&ssmap, (c_str){"foo"});
  delete(ssmap);
}
