//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// thread.c --
//
// Author           : Thierry Delisle
// Created On       : Tue Jan 17 12:27:26 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Mar 30 17:19:52 2018
// Update Count     : 8
//

#include "thread"

#include "kernel_private.h"

#define __CFA_INVOKE_PRIVATE__
#include "invoke.h"

extern "C" {
	#include <fenv.h>
	#include <stddef.h>
}

//extern volatile thread_local processor * this_processor;

//-----------------------------------------------------------------------------
// Thread ctors and dtors
void ?{}(thread_desc & this, const char * const name, cluster & cl, void * storage, size_t storageSize ) with( this ) {
	self_cor{ name, storage, storageSize };
	verify(&self_cor);
	curr_cor = &self_cor;
	self_mon.owner = &this;
	self_mon.recursion = 1;
	self_mon_p = &self_mon;
	curr_cluster = &cl;
	next = NULL;
	__cfaabi_dbg_debug_do(
		dbg_next = NULL;
		dbg_prev = NULL;
		__cfaabi_dbg_thread_register(&this);
	)

	monitors{ &self_mon_p, 1, (fptr_t)0 };
}

void ^?{}(thread_desc& this) with( this ) {
	^self_cor{};
}

forall( dtype T | sized(T) | is_thread(T) | { void ?{}(T&); } )
void ?{}( scoped(T)& this ) with( this ) {
	handle{};
	__thrd_start(handle);
}

forall( dtype T, ttype P | sized(T) | is_thread(T) | { void ?{}(T&, P); } )
void ?{}( scoped(T)& this, P params ) with( this ) {
	handle{ params };
	__thrd_start(handle);
}

forall( dtype T | sized(T) | is_thread(T) )
void ^?{}( scoped(T)& this ) with( this ) {
	^handle{};
}

//-----------------------------------------------------------------------------
// Starting and stopping threads
forall( dtype T | is_thread(T) )
void __thrd_start( T& this ) {
	coroutine_desc* thrd_c = get_coroutine(this);
	thread_desc   * thrd_h = get_thread   (this);
	thrd_c->last = TL_GET( this_coroutine );

	// __cfaabi_dbg_print_safe("Thread start : %p (t %p, c %p)\n", this, thrd_c, thrd_h);

	disable_interrupts();
	create_stack(&thrd_c->stack, thrd_c->stack.size);
	kernelTLS.this_coroutine = thrd_c;
	CtxStart(&this, CtxInvokeThread);
	assert( thrd_c->last->stack.context );
	CtxSwitch( thrd_c->last->stack.context, thrd_c->stack.context );

	ScheduleThread(thrd_h);
	enable_interrupts( __cfaabi_dbg_ctx );
}

extern "C" {
	// KERNEL ONLY
	void __finish_creation(void) {
		coroutine_desc* thrd_c = kernelTLS.this_coroutine;
		ThreadCtxSwitch( thrd_c, thrd_c->last );
	}
}

void yield( void ) {
	// Safety note : This could cause some false positives due to preemption
      verify( TL_GET( preemption_state ).enabled );
	BlockInternal( TL_GET( this_thread ) );
	// Safety note : This could cause some false positives due to preemption
      verify( TL_GET( preemption_state ).enabled );
}

void yield( unsigned times ) {
	for( unsigned i = 0; i < times; i++ ) {
		yield();
	}
}

// KERNEL ONLY
void ThreadCtxSwitch(coroutine_desc* src, coroutine_desc* dst) {
	// set state of current coroutine to inactive
	src->state = src->state == Halted ? Halted : Inactive;
	dst->state = Active;

	// set new coroutine that the processor is executing
	// and context switch to it
	kernelTLS.this_coroutine = dst;
	assert( src->stack.context );
	CtxSwitch( src->stack.context, dst->stack.context );
	kernelTLS.this_coroutine = src;

	// set state of new coroutine to active
	dst->state = dst->state == Halted ? Halted : Inactive;
	src->state = Active;
}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
