//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mutate.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Jul 15 14:50:04 2015
// Update Count     : 7
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <list>

#include "Mutate.h"
#include "ChooseMutator.h"
#include "LabelFixer.h"
#include "MLEMutator.h"
#include "CaseRangeMutator.h"
#include "ForExprMutator.h"
#include "LabelTypeChecker.h"
//#include "ExceptMutator.h"

#include "utility.h"

#include "SynTree/Visitor.h"

using namespace std;

namespace ControlStruct {
	void mutate( std::list< Declaration * > translationUnit ) {
		// hoist initialization out of for statements
		ForExprMutator formut;

		// normalizes label definitions and generates multi-level
		// exit labels
		LabelFixer lfix;

		// transform choose statements into switch statements
		ChooseMutator chmut;

		// expand case ranges and turn fallthru into a null statement
		CaseRangeMutator ranges;  // has to run after ChooseMutator

		//ExceptMutator exc;
		// LabelTypeChecker lbl;

		mutateAll( translationUnit, formut );
		acceptAll( translationUnit, lfix );
		mutateAll( translationUnit, chmut );
		mutateAll( translationUnit, ranges );
		//mutateAll( translationUnit, exc );
		//acceptAll( translationUnit, lbl );
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
