//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ForExprMutator.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Jul 14 12:14:44 2015
// Update Count     : 10
//

#include "SynTree/Mutator.h"
#include "SynTree/Statement.h"
#include "ForExprMutator.h"

namespace ControlStruct {
	Statement *ForExprMutator::mutate( ForStmt *forStmt ) {
		// recurse down all nest for loops to hoist any initializer declarations to make them C89 (rather than C99)
		forStmt->set_body( forStmt->get_body()->acceptMutator( *this ) );

		std::list<Statement *> &init = forStmt->get_initialization(); 
		if ( init.size() == 0 ) {
			return forStmt;
		} // if

		// create compound statement, move initializers outside, leave _for_ as-is
		CompoundStmt *block = new CompoundStmt( std::list< Label >() );
		std::list<Statement *> &stmts = block->get_kids();
		for ( std::list<Statement *>::iterator it = init.begin(); it != init.end(); ++it ) {
			stmts.push_back( *it );
		}	// for

		// add for to the new block
		stmts.push_back( forStmt );
		forStmt->set_initialization( std::list<Statement *>() );
		return block;

		return forStmt;
	}
} // namespace ControlStruct

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
