//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ConversionCost.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:37:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:38:24 2017
// Update Count     : 4
//

#pragma once

#include <functional>         // for function

#include "Cost.h"             // for Cost

#include "Common/PassVisitor.h"
#include "SynTree/Visitor.h"  // for Visitor
#include "SynTree/SynTree.h"  // for Visitor Nodes

namespace SymTab {
	class Indexer;
}  // namespace SymTab

namespace ResolvExpr {
	class TypeEnvironment;

	typedef std::function<Cost(Type *, Type *, const SymTab::Indexer &, const TypeEnvironment &)> CostFunction;
	struct ConversionCost : public WithShortCircuiting {
	  public:
		ConversionCost( Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env, CostFunction );

		Cost get_cost() const { return cost; }

		void previsit( BaseSyntaxNode * ) { visit_children = false; }

		void postvisit( VoidType * voidType );
		void postvisit( BasicType * basicType );
		void postvisit( PointerType * pointerType );
		void postvisit( ArrayType * arrayType );
		void postvisit( ReferenceType * refType );
		void postvisit( FunctionType * functionType );
		void postvisit( StructInstType * aggregateUseType );
		void postvisit( UnionInstType * aggregateUseType );
		void postvisit( EnumInstType * aggregateUseType );
		void postvisit( TraitInstType * aggregateUseType );
		void postvisit( TypeInstType * aggregateUseType );
		void postvisit( TupleType * tupleType );
		void postvisit( VarArgsType * varArgsType );
		void postvisit( ZeroType * zeroType );
		void postvisit( OneType * oneType );
	  protected:
		Type *dest;
		const SymTab::Indexer &indexer;
		Cost cost;
		const TypeEnvironment &env;
		CostFunction costFunc;
	};

	typedef std::function<int(Type *, Type *, const SymTab::Indexer &, const TypeEnvironment &)> PtrsFunction;
	Cost convertToReferenceCost( Type * src, ReferenceType * dest, const SymTab::Indexer & indexer, const TypeEnvironment & env, PtrsFunction func );
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
