//                              -*- Mode: CFA -*-
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// kernel_private.h --
//
// Author           : Thierry Delisle
// Created On       : Mon Feb 13 12:27:26 2017
// Last Modified By : Thierry Delisle
// Last Modified On : --
// Update Count     : 0
//

#ifndef KERNEL_PRIVATE_H
#define KERNEL_PRIVATE_H

#include "kernel"
#include "thread"

//-----------------------------------------------------------------------------
// Scheduler
void ScheduleThread( thread_desc * );
thread_desc * nextThread(cluster * this);

void ScheduleInternal();
void ScheduleInternal(spinlock * lock);
void ScheduleInternal(thread_desc * thrd);
void ScheduleInternal(spinlock * lock, thread_desc * thrd);

//-----------------------------------------------------------------------------
// Processor
struct processorCtx_t {
	processor * proc;
	coroutine_desc c;
};

DECL_COROUTINE(processorCtx_t);

void main(processorCtx_t *);
void start(processor * this);
void runThread(processor * this, thread_desc * dst);
void finishRunning(processor * this);
void spin(processor * this, unsigned int * spin_count);

//-----------------------------------------------------------------------------
// Threads
extern "C" {
      forall(dtype T | is_thread(T))
      void CtxInvokeThread(T * this);
}

extern void ThreadCtxSwitch(coroutine_desc * src, coroutine_desc * dst);

#endif //KERNEL_PRIVATE_H

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //