//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Tuples.h --
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Nov 9 13:17:58 2016
// Update Count     : 15
//

#ifndef _TUPLES_H_
#define _TUPLES_H_

#include <string>

#include "SynTree/Expression.h"
#include "SynTree/Declaration.h"
#include "SynTree/Type.h"

#include "ResolvExpr/AlternativeFinder.h"

namespace Tuples {
	// TupleAssignment.cc
	void handleTupleAssignment( ResolvExpr::AlternativeFinder & currentFinder, UntypedExpr * assign, const std::list<ResolvExpr::AltList> & possibilities );

	// TupleExpansion.cc
	/// expands z.[a, b.[x, y], c] into [z.a, z.b.x, z.b.y, z.c], inserting UniqueExprs as appropriate
	void expandMemberTuples( std::list< Declaration * > & translationUnit );

	/// replaces tuple-related elements, such as TupleType, TupleExpr, TupleAssignExpr, etc.
	void expandTuples( std::list< Declaration * > & translationUnit );

	/// replaces UniqueExprs with a temporary variable and one call
	void expandUniqueExpr( std::list< Declaration * > & translationUnit );

	/// returns VoidType if any of the expressions have Voidtype, otherwise TupleType of the Expression result types
	Type * makeTupleType( const std::list< Expression * > & exprs );

	/// returns true if the expression may contain side-effects.
	bool maybeImpure( Expression * expr );
} // namespace Tuples

#endif // _TUPLE_ASSIGNMENT_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
