#pragma once

#include "SynTree/Visitor.h"

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Deep magic (a.k.a template meta programming) to make the templated visitor work
//Basically the goal is to make 2 previsit_impl
// 1 - 
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
template<typename pass_type, typename node_type>
static inline auto previsit_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.previsit( node ), void() ) {
	pass.previsit( node );
}

template<typename pass_type, typename node_type>
static inline void previsit_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) {
	//Do nothing
}


template<typename pass_type, typename node_type>
static inline auto postvisit_impl( pass_type& pass, node_type * node, __attribute__((unused)) int unused ) ->decltype( pass.postvisit( node ), void() ) {
	pass.postvisit( node );
}

template<typename pass_type, typename node_type>
static inline auto postvisit_impl( __attribute__((unused)) pass_type& pass, node_type * node, __attribute__((unused)) long unused ) {
	//Do nothing
}

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//Templated visitor type

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
template< typename pass_type >
class PassVisitor final : public Visitor {
public:
	PassVisitor() = default;

	template< typename... Args >
	PassVisitor(Args &&... args) 
		: pass( std::forward<Args>( args )... )
	{}

	virtual ~PassVisitor() = default;
private:
	pass_type pass;

public:

	virtual void visit( ObjectDecl *objectDecl ) override final;
	virtual void visit( FunctionDecl *functionDecl ) override final;
	virtual void visit( StructDecl *aggregateDecl ) override final;
	virtual void visit( UnionDecl *aggregateDecl ) override final;
	virtual void visit( EnumDecl *aggregateDecl ) override final;
	virtual void visit( TraitDecl *aggregateDecl ) override final;
	virtual void visit( TypeDecl *typeDecl ) override final;
	virtual void visit( TypedefDecl *typeDecl ) override final;
	virtual void visit( AsmDecl *asmDecl ) override final;

	virtual void visit( CompoundStmt *compoundStmt ) override final;
	virtual void visit( ExprStmt *exprStmt ) override final;
	virtual void visit( AsmStmt *asmStmt ) override final;
	virtual void visit( IfStmt *ifStmt ) override final;
	virtual void visit( WhileStmt *whileStmt ) override final;
	virtual void visit( ForStmt *forStmt ) override final;
	virtual void visit( SwitchStmt *switchStmt ) override final;
	virtual void visit( CaseStmt *caseStmt ) override final;
	virtual void visit( BranchStmt *branchStmt ) override final;
	virtual void visit( ReturnStmt *returnStmt ) override final;
	virtual void visit( TryStmt *tryStmt ) override final;
	virtual void visit( CatchStmt *catchStmt ) override final;
	virtual void visit( FinallyStmt *finallyStmt ) override final;
	virtual void visit( NullStmt *nullStmt ) override final;
	virtual void visit( DeclStmt *declStmt ) override final;
	virtual void visit( ImplicitCtorDtorStmt *impCtorDtorStmt ) override final;

	virtual void visit( ApplicationExpr *applicationExpr ) override final;
	virtual void visit( UntypedExpr *untypedExpr ) override final;
	virtual void visit( NameExpr *nameExpr ) override final;
	virtual void visit( CastExpr *castExpr ) override final;
	virtual void visit( AddressExpr *addressExpr ) override final;
	virtual void visit( LabelAddressExpr *labAddressExpr ) override final;
	virtual void visit( UntypedMemberExpr *memberExpr ) override final;
	virtual void visit( MemberExpr *memberExpr ) override final;
	virtual void visit( VariableExpr *variableExpr ) override final;
	virtual void visit( ConstantExpr *constantExpr ) override final;
	virtual void visit( SizeofExpr *sizeofExpr ) override final;
	virtual void visit( AlignofExpr *alignofExpr ) override final;
	virtual void visit( UntypedOffsetofExpr *offsetofExpr ) override final;
	virtual void visit( OffsetofExpr *offsetofExpr ) override final;
	virtual void visit( OffsetPackExpr *offsetPackExpr ) override final;
	virtual void visit( AttrExpr *attrExpr ) override final;
	virtual void visit( LogicalExpr *logicalExpr ) override final;
	virtual void visit( ConditionalExpr *conditionalExpr ) override final;
	virtual void visit( CommaExpr *commaExpr ) override final;
	virtual void visit( TypeExpr *typeExpr ) override final;
	virtual void visit( AsmExpr *asmExpr ) override final;
	virtual void visit( ImplicitCopyCtorExpr *impCpCtorExpr ) override final;
	virtual void visit( ConstructorExpr * ctorExpr ) override final;
	virtual void visit( CompoundLiteralExpr *compLitExpr ) override final;
	virtual void visit( UntypedValofExpr *valofExpr ) override final;
	virtual void visit( RangeExpr *rangeExpr ) override final;
	virtual void visit( UntypedTupleExpr *tupleExpr ) override final;
	virtual void visit( TupleExpr *tupleExpr ) override final;
	virtual void visit( TupleIndexExpr *tupleExpr ) override final;
	virtual void visit( MemberTupleExpr *tupleExpr ) override final;
	virtual void visit( TupleAssignExpr *assignExpr ) override final;
	virtual void visit( StmtExpr * stmtExpr ) override final;
	virtual void visit( UniqueExpr * uniqueExpr ) override final;

	virtual void visit( VoidType *basicType ) override final;
	virtual void visit( BasicType *basicType ) override final;
	virtual void visit( PointerType *pointerType ) override final;
	virtual void visit( ArrayType *arrayType ) override final;
	virtual void visit( FunctionType *functionType ) override final;
	virtual void visit( StructInstType *aggregateUseType ) override final;
	virtual void visit( UnionInstType *aggregateUseType ) override final;
	virtual void visit( EnumInstType *aggregateUseType ) override final;
	virtual void visit( TraitInstType *aggregateUseType ) override final;
	virtual void visit( TypeInstType *aggregateUseType ) override final;
	virtual void visit( TupleType *tupleType ) override final;
	virtual void visit( TypeofType *typeofType ) override final;
	virtual void visit( AttrType *attrType ) override final;
	virtual void visit( VarArgsType *varArgsType ) override final;
	virtual void visit( ZeroType *zeroType ) override final;
	virtual void visit( OneType *oneType ) override final;

	virtual void visit( SingleInit *singleInit ) override final;
	virtual void visit( ListInit *listInit ) override final;
	virtual void visit( ConstructorInit *ctorInit ) override final;

	virtual void visit( Subrange *subrange ) override final;

	virtual void visit( Constant *constant ) override final;

private:
	template<typename node_type> 
	auto call_previsit ( node_type * node ) 
		-> decltype( previsit_impl ( pass, node, 0 ), void() ) 
	{ 
		previsit_impl ( pass, node, 0 ); 
	}

	template<typename node_type> 
	auto call_postvisit( node_type * node )
		-> decltype( postvisit_impl( pass, node, 0 ), void() ) 
	{ 
		postvisit_impl( pass, node, 0 ); 
	}
};

#include "PassVisitor.impl.h"