//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mutate.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug  4 11:39:08 2016
// Update Count     : 9
//

#include <iterator>                // for back_inserter, inserter
#include <list>                    // for list

#include "Common/PassVisitor.h"    // for mutateAll
#include "Common/SemanticError.h"  // for SemanticError
#include "ForExprMutator.h"        // for ForExprMutator
#include "LabelFixer.h"            // for LabelFixer
#include "Mutate.h"
#include "SynTree/Declaration.h"   // for Declaration
#include "SynTree/Mutator.h"       // for mutateAll
//#include "ExceptMutator.h"

#include "Common/PassVisitor.h"    // for PassVisitor
#include "SynTree/Visitor.h"       // for acceptAll

using namespace std;

namespace ControlStruct {
	void mutate( std::list< Declaration * > translationUnit ) {
		// hoist initialization out of for statements
		PassVisitor<ForExprMutator> formut;

		// normalizes label definitions and generates multi-level exit labels
		LabelFixer lfix;

		//ExceptMutator exc;

		mutateAll( translationUnit, formut );
		acceptAll( translationUnit, lfix );
		//mutateAll( translationUnit, exc );
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
