// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// math2.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 22 14:59:21 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May 24 21:06:10 2018
// Update Count     : 82
// 

#include <fstream>
#include <math>

int main( void ) {
	float f;
	double d;
	long double l;

	//---------------------- Logarithm ----------------------

	sout | "log:" | log( 1.0F ) | log( 1.0D ) | log( 1.0L ) | log( 1.0F+1.0FI ) | log( 1.0D+1.0DI ) | log( 1.0DL+1.0LI ) | endl;
	sout | "log2:" | log2( 8.0F ) | log2( 8.0D ) | log2( 8.0L ) | endl;
	sout | "log10:" | log10( 100.0F ) | log10( 100.0D ) | log10( 100.0L ) | endl;
	sout | "log1p:" | log1p( 1.0F ) | log1p( 1.0D ) | log1p( 1.0L ) | endl;
	sout | "ilogb:" | ilogb( 1.0F ) | ilogb( 1.0D ) | ilogb( 1.0L ) | endl;
	sout | "logb:" | logb( 8.0F ) | logb( 8.0D ) | logb( 8.0L ) | endl;

	sout | "sqrt:" | sqrt( 1.0F ) | sqrt( 1.0D ) | sqrt( 1.0L ) | sqrt( 1.0F+1.0FI ) | sqrt( 1.0D+1.0DI ) | sqrt( 1.0DL+1.0LI ) | endl;
	sout | "cbrt:" | cbrt( 27.0F ) | cbrt( 27.0D ) | cbrt( 27.0L ) | endl;
	sout | "hypot:" | hypot( 1.0F, -1.0F ) | hypot( 1.0D, -1.0D ) | hypot( 1.0L, -1.0L ) | endl;

	//---------------------- Trigonometric ----------------------

	sout | "sin:" | sin( 1.0F ) | sin( 1.0D ) | sin( 1.0L ) | sin( 1.0F+1.0FI ) | sin( 1.0D+1.0DI ) | sin( 1.0DL+1.0LI ) | endl;
	sout | "cos:" | cos( 1.0F ) | cos( 1.0D ) | cos( 1.0L ) | cos( 1.0F+1.0FI ) | cos( 1.0D+1.0DI ) | cos( 1.0DL+1.0LI ) | endl;
	sout | "tan:" | tan( 1.0F ) | tan( 1.0D ) | tan( 1.0L ) | tan( 1.0F+1.0FI ) | tan( 1.0D+1.0DI ) | tan( 1.0DL+1.0LI ) | endl;
	sout | "asin:" | asin( 1.0F ) | asin( 1.0D ) | asin( 1.0L ) | asin( 1.0F+1.0FI ) | asin( 1.0D+1.0DI ) | asin( 1.0DL+1.0LI ) | endl;
	sout | "acos:" | acos( 1.0F ) | acos( 1.0D ) | acos( 1.0L ) | acos( 1.0F+1.0FI ) | acos( 1.0D+1.0DI ) | acos( 1.0DL+1.0LI ) | endl;
	sout | "atan:" | atan( 1.0F ) | atan( 1.0D ) | atan( 1.0L ) | atan( 1.0F+1.0FI ) | atan( 1.0D+1.0DI ) | atan( 1.0DL+1.0LI ) | endl;
	sout | "atan2:" | atan2( 1.0F, 1.0F ) | atan2( 1.0D, 1.0D ) | atan2( 1.0L, 1.0L );
	sout | "atan:" | atan( 1.0F, 1.0F ) | atan( 1.0D, 1.0D ) | atan( 1.0L, 1.0L ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa math2.c" //
// End: //
