//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// libdebug.h --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : Mon Nov 28 12:27:26 2016
// Update Count     : 0
//

#ifndef __LIB_DEBUG_H__
#define __LIB_DEBUG_H__

#ifdef __CFA_DEBUG__
      #define LIB_DEBUG_DO(x) x
      #define LIB_NO_DEBUG_DO(x) ((void)0)
#else
      #define LIB_DEBUG_DO(x) ((void)0)
      #define LIB_NO_DEBUG_DO(x) x      
#endif

#ifdef __cforall
extern "C" {
#endif
      #include <stdarg.h>

      extern void __lib_debug_write( int fd, const char *buffer, int len );
      extern void __lib_debug_acquire();
      extern void __lib_debug_release();
      extern void __lib_debug_print_safe  ( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __lib_debug_print_nolock( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __lib_debug_print_vararg( const char fmt[], va_list arg );
      extern void __lib_debug_print_buffer( char buffer[], int buffer_size, const char fmt[], ... ) __attribute__(( format (printf, 3, 4) ));
#ifdef __cforall
}
#endif

#ifdef __CFA_DEBUG_PRINT__
      #define LIB_DEBUG_WRITE( fd, buffer, len )  __lib_debug_write( fd, buffer, len )
      #define LIB_DEBUG_ACQUIRE()                 __lib_debug_acquire()
      #define LIB_DEBUG_RELEASE()                 __lib_debug_release()
      #define LIB_DEBUG_PRINT_SAFE(...)           __lib_debug_print_safe   (__VA_ARGS__)
      #define LIB_DEBUG_PRINT_NOLOCK(...)         __lib_debug_print_nolock (__VA_ARGS__)
      #define LIB_DEBUG_PRINT_BUFFER(...)         __lib_debug_print_buffer (__VA_ARGS__)
#else
      #define LIB_DEBUG_WRITE(...)          ((void)0)
      #define LIB_DEBUG_ACQUIRE()           ((void)0)
      #define LIB_DEBUG_RELEASE()           ((void)0)
      #define LIB_DEBUG_PRINT_SAFE(...)     ((void)0)
      #define LIB_DEBUG_PRINT_NOLOCK(...)   ((void)0)
      #define LIB_DEBUG_PRINT_BUFFER(...)   ((void)0)
#endif

#endif //__LIB_DEBUG_H__

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
