//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AddVisit.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 16:14:32 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr  7 14:42:21 2016
// Update Count     : 5
//

namespace SymTab {
	void addDecls( std::list< Declaration* > &declsToAdd, std::list< Statement* > &statements, std::list< Statement* >::iterator i );

	template< typename Visitor >
	inline void addVisitStatementList( std::list< Statement* > &statements, Visitor &visitor ) {
		for ( std::list< Statement* >::iterator i = statements.begin(); i != statements.end(); ++i ) {
			addDecls( visitor.get_declsToAdd(), statements, i );
			(*i)->accept( visitor );
		} // for
		addDecls( visitor.get_declsToAdd(), statements, statements.end() );
	}

	template< typename Visitor >
	inline void addVisit(CompoundStmt *compoundStmt, Visitor &visitor) {
		addVisitStatementList( compoundStmt->get_kids(), visitor );
	}

	template< typename Visitor >
	inline void addVisit(SwitchStmt *switchStmt, Visitor &visitor) {
		addVisitStatementList( switchStmt->get_branches(), visitor );
		maybeAccept( switchStmt->get_condition(), visitor );
	}

	template< typename Visitor >
	inline void addVisit(ChooseStmt *switchStmt, Visitor &visitor) {
		addVisitStatementList( switchStmt->get_branches(), visitor );
		maybeAccept( switchStmt->get_condition(), visitor );
	}

	// template< typename Visitor >
	// inline void addVisit(CaseStmt *caseStmt, Visitor &visitor) {
	// 	addVisitStatementList( caseStmt->get_statements(), visitor );
	// 	maybeAccept( caseStmt->get_condition(), visitor );
	// }
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
