//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// RenameVars.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:10:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 17:36:39 2016
// Update Count     : 3
//

#ifndef RESOLVEXPR_RENAMEVARS_H
#define RESOLVEXPR_RENAMEVARS_H

#include <list>
#include <map>
#include <string>

#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"

namespace ResolvExpr {

	/// Provides a consistent renaming of forall type names in a hierarchy by prefixing them with a unique "level" ID
	class RenameVars : public Visitor {
	  public:
		RenameVars();
		void reset();
	  private:
		virtual void visit( VoidType *basicType );
		virtual void visit( BasicType *basicType );
		virtual void visit( PointerType *pointerType );
		virtual void visit( ArrayType *arrayType );
		virtual void visit( FunctionType *functionType );
		virtual void visit( StructInstType *aggregateUseType );
		virtual void visit( UnionInstType *aggregateUseType );
		virtual void visit( EnumInstType *aggregateUseType );
		virtual void visit( TraitInstType *aggregateUseType );
		virtual void visit( TypeInstType *aggregateUseType );
		virtual void visit( TupleType *tupleType );
		virtual void visit( VarArgsType *varArgsType );

		void typeBefore( Type *type );
		void typeAfter( Type *type );
		int level;
		std::list< std::map< std::string, std::string > > mapStack;
	};

	extern RenameVars global_renamer;
} // namespace ResolvExpr

#endif // RENAMEVARS_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
