//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// random.c --
//
// Author           : Peter A. Buhr
// Created On       : Tue Jul  5 21:29:30 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan  2 12:19:34 2018
// Update Count     : 19
//

#include <fstream.hfa>
#include <stdlib.hfa>										// random
#include <unistd.h>										// getpid

int main() {
	// srandom( getpid() );								// set random seed
	srandom( 1003 );									// fixed seed for repeatable tests

	// test polymorphic calls to random and stream
	char c = random();
	sout | c | endl;
	c = random( 'A' );
	sout | c | endl;
	c = random( 'A', 'Z' );
	sout | c | endl;

	int i = random();
    sout | i | endl;
	i = random( 10 );
    sout | i | endl;
	i = random( -10, 20 );
    sout | i | endl;

	unsigned int ui = random();
    sout | ui | endl;
	ui = random( 10u );
    sout | ui | endl;
	ui = random( 10u, 20u );
    sout | ui | endl;

	long int li = random();
    sout | li | endl;
	li = random( 10l );
    sout | li | endl;
	li = random( -10l, 20l );
    sout | li | endl;

	unsigned long int uli = random();
    sout | uli | endl;
	uli = random( 10ul );
    sout | uli | endl;
	uli = random( 10ul, 20ul );
    sout | uli | endl;

    float f = random();
    sout | f | endl;

    double d = random();
    sout | d | endl;

    float _Complex fc = random();
    sout | fc | endl;

    double _Complex dc = random();
    sout | dc | endl;

    long double _Complex ldc = random();
    sout | ldc | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa random.c" //
// End: //
