//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// math4.c --
//
// Author           : Peter A. Buhr
// Created On       : Thu May 24 20:56:54 2018
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May 24 20:58:06 2018
// Update Count     : 2
//

#include <fstream.hfa>
#include <math.hfa>

int main( void ) {
	float f;
	double d;
	long double l;

	//---------------------- Nearest Integer ----------------------

	sout | "floor:" | floor( 1.2F ) | floor( 1.2D ) | floor( 1.2L ) | endl;
	sout | "ceil:" | ceil( 1.6F ) | ceil( 1.6D ) | ceil( 1.6L ) | endl;
	sout | "trunc:" | trunc( 3.5F ) | trunc( 3.5D ) | trunc( 3.5L ) | endl;
	sout | "rint:" | (float)rint( 1.5F ) | (double)rint( 1.5D ) | (long double)rint( 1.5L ) | endl;
	sout | "rint:" | (long int)rint( 1.5F ) | (long int)rint( 1.5D ) | (long int)rint( 1.5L ) | endl;
	sout | "rint:" | (long long int)rint( 1.5F ) | (long long int)rint( 1.5D ) | (long long int)rint( 1.5L ) | endl;
	sout | "lrint:" | lrint( 1.5F ) | lrint( 1.5D ) | lrint( 1.5L ) | endl;
	sout | "llrint:" | llrint( 1.5F ) | llrint( 1.5D ) | llrint( 1.5L ) | endl;
	sout | "nearbyint:" | nearbyint( 3.5F ) | nearbyint( 3.5D ) | nearbyint( 3.5L ) | endl;
	sout | "round:" | (float)round( 1.5F ) | (double)round( 1.5D ) | (long double)round( 1.5L ) | endl;
	sout | "round:" | (long int)round( 1.5F ) | (long int)round( 1.5D ) | (long int)round( 1.5L ) | endl;
	sout | "round:" | (long long int)round( 1.5F ) | (long long int)round( 1.5D ) | (long long int)round( 1.5L ) | endl;
	sout | "lround:" | lround( 1.5F ) | lround( 1.5D ) | lround( 1.5L ) | endl;
	sout | "llround:" | llround( 1.5F ) | llround( 1.5D ) | llround( 1.5L ) | endl;

	//---------------------- Manipulation ----------------------

	sout | "copysign:" | copysign( 1.0F, -1.0F ) | copysign( 1.0D, -1.0D ) | copysign( 1.0L, -1.0L ) | endl;
	int exp;
	f = frexp( 4.0F, &exp );
	sout | "frexp:" | f | exp;
	d = frexp( 4.0D, &exp );
	sout | d | exp;
	l = frexp( 4.0L, &exp );
	sout | l | exp | endl;
	sout | "ldexp:" | ldexp( 2.0F, 2 ) | ldexp( 2.0D, 2 ) | ldexp( 2.0L, 2 ) | endl;
	float fi;
	double di;
	long double ldi;
	f = modf( 2.3F, &fi );
	sout | "modf:" | fi | f;
	d = modf( 2.3D, &di );
	sout | di | d;
	l = modf( 2.3L, &ldi );
	sout | ldi | l | endl;
	sout | "modf:" | modf( 2.3F ) | modf( 2.3D ) | modf( 2.3L ) | endl;
	sout | "nextafter:" | nextafter( 2.0F, 3.0F ) | nextafter( 2.0D, 3.0D ) | nextafter( 2.0L, 3.0L ) | endl;
	sout | "nexttoward:" | nexttoward( 2.0F, 3.0F ) | nexttoward( 2.0D, 3.0D ) | nexttoward( 2.0L, 3.0L ) | endl;

	sout | "scalbn:" | scalbn( 2.0F, 3 ) | scalbn( 2.0D, 3 ) | scalbn( 2.0L, 3 ) | endl;
	sout | "scalbln:" | scalbln( 2.0F, 3L ) | scalbln( 2.0D, 3L ) | scalbln( 2.0L, 3L ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa math3.c" //
// End: //
