#include <limits.hfa>

forall(otype T)
union ByteView {
	T val;
	char bytes[(sizeof(int))]; // want to change to sizeof(T)
};

forall(otype T)
void print(ByteView(T) x) {
	for (int i = 0; i < sizeof(int); i++) { // want to change to sizeof(T)
		printf("%02x", x.bytes[i] & 0xff);
	}
}

forall(otype T)
void f(ByteView(T) x, T val) {
	print(x);
	printf(" ");
	x.val = val;
	print(x);
	printf("\n");
}

int main() {
	ByteView(unsigned) u = { 0 };
	ByteView(int) i = { 0 };
	f(u, MAX);
	f(i, -1);
}
