// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// counter.c -- 
// 
// Author           : Aaron B. Moss
// Created On       : Thu Feb 22 15:27:00 2018
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu Feb 22 15:27:00 2018
// Update Count     : 1
// 

// Tests unified increment/decrement builtin functions.
// Could be extended for other arithmetic unifications

struct counter { int x; };

counter& ?+=?( counter& c, one_t ) { ++c.x; return c; }

counter& ?-=?( counter& c, one_t ) { --c.x; return c; }

int main() {
    counter c = { 42 };
    c += 1;
    ++c;
    c++;
    printf("%d\n", c.x);
    c -= 1;
    --c;
    c--;
    printf("%d\n", c.x);
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa counter.c" //
// End: //