//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// quad.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar  8 22:07:02 2016
// Update Count     : 8
//

#include <fstream.hfa>

forall( otype T | { T ?*?( T, T ); } )
T square( T t ) {
	return t * t;
}

forall( otype U | { U square( U ); } )
U quad( U u ) {
	return square( square( u ) );
}

int main() {
	int N = 2;
	sout | "result of quad of" | N | "is" | quad( N ) | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa quad.c" //
// End: //
