//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// it_out.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar  8 22:14:39 2016
// Update Count     : 8
//

typedef unsigned long streamsize_type;

trait ostream( dtype os_type ) {
	os_type *write( os_type *, const char *, streamsize_type );
	int fail( os_type * );
};

trait writeable( otype T ) {
	forall( dtype os_type | ostream( os_type ) ) os_type * ?<<?( os_type *, T );
};

forall( dtype os_type | ostream( os_type ) ) os_type * ?<<?( os_type *, char );
forall( dtype os_type | ostream( os_type ) ) os_type * ?<<?( os_type *, int );
forall( dtype os_type | ostream( os_type ) ) os_type * ?<<?( os_type *, const char * );

trait istream( dtype is_type ) {
	is_type *read( is_type *, char *, streamsize_type );
	is_type *unread( is_type *, char );
	int fail( is_type * );
	int eof( is_type * );
};

trait readable( otype T ) {
	forall( dtype is_type | istream( is_type ) ) is_type * ?<<?( is_type *, T );
};

forall( dtype is_type | istream( is_type ) ) is_type * ?>>?( is_type *, char* );
forall( dtype is_type | istream( is_type ) ) is_type * ?>>?( is_type *, int* );

trait iterator( otype iterator_type, otype elt_type ) {
	iterator_type ?++( iterator_type* );
	iterator_type ++?( iterator_type* );
	int ?==?( iterator_type, iterator_type );
	int ?!=?( iterator_type, iterator_type );

	lvalue elt_type *?( iterator_type );
};

forall( otype elt_type | writeable( elt_type ),
		otype iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_all( iterator_type begin, iterator_type end, os_type *os );

forall( otype elt_type | writeable( elt_type ),
		otype iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_all( elt_type begin, iterator_type end, os_type *os ) {
	os << begin;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa it_out.c" //
// End: //
