#include "gc.h"

#include <stdio.h>

struct List_t
{
	gcpointer(List_t) next;
	int val;
};

typedef gcpointer(List_t) LLL;

#define MAX (1024 * 1)

LLL buildLLL(int sz)
{
	int i = 0;
	LLL ll0;

	gcmalloc( &ll0 );
	List_t* ll0_ptr = get( &ll0 );
	ll0_ptr->val = i;
	LLL lll = ll0;

	for (i = 1; i < sz; i++)
	{
		LLL llc;
		gcmalloc( &llc );
		List_t* llc_ptr = get( &llc );
		llc_ptr->val = i;
		List_t* lll_ptr = get( &lll );
		lll_ptr->next = llc;

		lll = llc;
	}

	check(is_valid( &ll0.internal ));

	return ll0;
}

void testLLL(LLL lll)
{
	unsigned char *counted;

	counted = (unsigned char *) calloc(MAX, sizeof(unsigned char));
	while (lll)
	{
		List_t* lll_ptr = get( &lll );
		counted[lll_ptr->val]++;
		if (counted[lll_ptr->val] > 1)
		{
			fprintf(stderr, "ERROR! Encountered %d twice!\n", lll_ptr->val);
			exit(1);
		}
		lll = lll_ptr->next;
	}

	return;
}

int main(void)
{
	LLL mylll;

	mylll = buildLLL(MAX);

	testLLL(mylll);

	return 0;
}
