#pragma once

#include "tools/checks.h"
#include "tools/print.h"

// forall(otype T)
// inline void swap(T* const a, T* const b)
// {
// 	T* temp = a;
// 	*a = *b;
// 	*b = *temp;
// }

trait has_equal(otype T)
{
	signed int ?==?(T a, T b);
};

trait InputIterator_t(otype T, otype InputIterator)
{
	signed int ?==?(InputIterator a, InputIterator b);
	signed int ?!=?(InputIterator a, InputIterator b);
	T *?(InputIterator a);
	InputIterator ++?(InputIterator* a);
	InputIterator ?++(InputIterator* a);
};

forall(otype T | has_equal(T), otype InputIterator | InputIterator_t(T, InputIterator))
static inline InputIterator find( InputIterator first, const InputIterator* const last, T val)
{
	while ( first != *last)
	{
		if(*first == val) return first;
		++first;
	}
	return *last;
}
