//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// io1.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed Mar  2 16:56:02 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu May 24 21:17:56 2018
// Update Count     : 104
//

#include <fstream.hfa>

int main() {
	int x = 3, y = 5, z = 7;
	sout | x * 3 | y + 1 | z << 2 | x == y | (x | y) | (x || y) | (x > z ? 1 : 2) | endl;
	sout | 1 | 2 | 3 | endl;
	sout | '1' | '2' | '3' | endl;
	sout | 1 | "" | 2 | "" | 3 | endl;
	sout | endl;

	sout | "opening delimiters" | endl;
	sout
		 | "x (" | 1
		 | "x [" | 2
		 | "x {" | 3
		 | "x =" | 4
		 | "x $" | 5
		 | "x £" | 6
		 | "x ¥" | 7
		 | "x ¡" | 8
		 | "x ¿" | 9
		 | "x «" | 10
		 | endl | endl;

	sout | "closing delimiters" | endl;
	sout
		 | 1 | ", x"
		 | 2 | ". x"
		 | 3 | "; x"
		 | 4 | "! x"
		 | 5 | "? x"
		 | 6 | "% x"
		 | 7 | "¢ x"
		 | 8 | "» x"
		 | 9 | ") x"
		 | 10 | "] x"
		 | 11 | "} x"
		 | endl | endl;

	sout | "opening/closing delimiters" | endl;
	sout
		 | "x`" | 1 | "`x'" | 2
		 | "'x\"" | 3 | "\"x:" | 4
		 | ":x " | 5 | " x\t" | 6
		 | "\tx\f" | 7 | "\fx\v" | 8
		 | "\vx\n" | 9 | "\nx\r" | 10
		 | "\rx"
		 | endl | endl;

	sout | "override opening/closing delimiters" | endl;
	sout | "x ( " | 1 | " ) x" | 2 | " , x" | 3 | " :x: " | 4 | endl;
	sout | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa io1.c" //
// End: //
