//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// identity.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jun  8 08:21:32 2017
// Update Count     : 18
//

#include <fstream.hfa>

forall( otype T )
T identity( T t ) {
	return t;
}

int main() {
	sout | "char\t\t\t"					| identity( 'z' ) | endl;
	sout | "signed int\t\t"				| identity( 4 ) | endl;
	sout | "unsigned int\t\t"			| identity( 4u ) | endl;
	sout | "signed long int\t\t" 		| identity( 4l ) | endl;
	sout | "unsigned long int\t" 		| identity( 4ul ) | endl;
	sout | "signed long long int\t"		| identity( 4ll ) | endl;
	sout | "unsigned long long int\t"	| identity( 4ull ) | endl;
	sout | "float\t\t\t" 				| identity( 4.1f ) | endl;
	sout | "double\t\t\t"				| identity( 4.1 ) | endl;
	sout | "long double\t\t"			| identity( 4.1l ) | endl;
	sout | "float _Complex\t\t"			| identity( -4.1F-2.0iF ) | endl;
	sout | "double _Complex\t\t"		| identity( -4.1D-2.0iD ) | endl;
	sout | "long double _Complex\t"		| identity( -4.1L-2.0iL ) | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa identity.c" //
// End: //
