#pragma once

// #include <stddef.h>
// #include <stdint.h>
//
// static const size_t POOL_SIZE_EXP = 24;
// static const size_t POOL_SIZE_BYTES = 0x1 << POOL_SIZE_EXP;
// static const size_t POOL_PTR_MASK = ~(POOL_SIZE_BYTES - 1);
//
// static const size_t CARDS_SIZE_EXP = 12;
// static const size_t CARDS_SIZE_BYTES = 0x1 << CARDS_SIZE_EXP;
// static const size_t CARDS_OFFSET_MASK = (~(CARDS_SIZE_BYTES - 1)) & (POOL_SIZE_BYTES - 1);
// static const size_t CARDS_COUNT = POOL_SIZE_BYTES / CARDS_SIZE_BYTES;
//
// static const size_t OBJECT_ALLIGNMENT = sizeof(size_t);
// static const size_t OBJECT_PTR_MASK = ~(OBJECT_ALLIGNMENT - 1);

enum {
	POOL_SIZE_EXP 	= 24,
	POOL_SIZE_BYTES 	= 0x1 << POOL_SIZE_EXP,
	POOL_PTR_MASK 	= ~(POOL_SIZE_BYTES - 1),

	CARDS_SIZE_EXP 	= 12,
	CARDS_SIZE_BYTES 	= 0x1 << CARDS_SIZE_EXP,
	CARDS_OFFSET_MASK	= (~(CARDS_SIZE_BYTES - 1)) & (POOL_SIZE_BYTES - 1),
	CARDS_COUNT 	= POOL_SIZE_BYTES / CARDS_SIZE_BYTES,

	OBJECT_ALLIGNMENT	= sizeof(size_t),
	OBJECT_PTR_MASK 	= ~(OBJECT_ALLIGNMENT - 1),
};
