
#include <stdbool.h>
#include <stdlib.hfa>

trait allocator_c(otype T, otype allocator_t)
{
	void realloc(allocator_t* const, size_t);
};

forall(otype T)
struct heap_allocator
{
	T* storage;
	size_t capacity;
};

forall(otype T)
inline void realloc(heap_allocator(T) *const this, size_t size)
{
	this->storage = (T*)realloc((void*)this->storage, this->capacity);
}
