
#include <stdbool.h>
#include <stdlib.hfa>

#define POOL_SIZE_EXP 24
#define POOL_SIZE_BYTES 0x1 << POOL_SIZE_EXP
#define POOL_PTR_MASK ~(POOL_SIZE_BYTES - 1)

#define CARDS_SIZE_EXP 12
#define CARDS_SIZE_BYTES 0x1 << CARDS_SIZE_EXP
#define CARDS_OFFSET_MASK (~(CARDS_SIZE_BYTES - 1)) & (POOL_SIZE_BYTES - 1)
#define CARDS_COUNT POOL_SIZE_BYTES / CARDS_SIZE_BYTES

struct card_table_t
{
	size_t count;
	void* cards_start[CARDS_COUNT];
};
