//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeofType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:13:29 2015
// Update Count     : 2
//

#include "Type.h"
#include "Expression.h"
#include "utility.h"

TypeofType::TypeofType( const Type::Qualifiers &tq, Expression *expr ) : Type( tq ), expr( expr ) {
}

TypeofType::TypeofType( const TypeofType &other ) : Type( other ), expr( maybeClone( other.expr ) ) {
}

TypeofType::~TypeofType() {
	delete expr;
}

void TypeofType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << "type-of expression ";
	if ( expr ) {
		expr->print( os, indent );
	}
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
