//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeDecl.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:02:11 2015
// Update Count     : 1
//

#include "Declaration.h"
#include "Type.h"
#include "utility.h"

TypeDecl::TypeDecl( const std::string &name, StorageClass sc, Type *type, Kind kind ) : Parent( name, sc, type ), kind( kind ) {
}

TypeDecl::TypeDecl( const TypeDecl &other ) : Parent( other ), kind( other.kind ) {
}

std::string TypeDecl::typeString() const {
	static const char *kindNames[] = { "type", "incomplete type", "function type" };
	return kindNames[ kind ];
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
