//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TupleExpr.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 10:59:19 2015
// Update Count     : 1
//

#include "Expression.h"
#include "utility.h"

TupleExpr::TupleExpr( Expression *_aname ) : Expression( _aname ) {
}

TupleExpr::TupleExpr( const TupleExpr &other ) : Expression( other ) {
	cloneAll( other.exprs, exprs );
}

TupleExpr::~TupleExpr() {
	deleteAll( exprs );
}

void TupleExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Tuple:" << std::endl;
	printAll( exprs, os, indent+2 );
	Expression::print( os, indent );
}

SolvedTupleExpr::SolvedTupleExpr( std::list<Expression *> &_exprs, Expression *_aname ) : Expression( _aname ) {
	std::copy(_exprs.begin(), _exprs.end(), back_inserter(exprs));
}

SolvedTupleExpr::SolvedTupleExpr( const SolvedTupleExpr &other ) : Expression( other ) {
	cloneAll( other.exprs, exprs );
}

void SolvedTupleExpr::print( std::ostream &os, int indent ) const {
	os << std::string( indent, ' ' ) << "Solved Tuple:" << std::endl;
	printAll( exprs, os, indent+2 );
	Expression::print( os, indent );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
