//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// PointerType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 10:15:16 2015
// Update Count     : 2
//

#include "Type.h"
#include "Expression.h"
#include "utility.h"

PointerType::PointerType( const Type::Qualifiers &tq, Type *base )
	: Type( tq ), base( base ), dimension( 0 ), isVarLen( false ), isStatic( false ) {
	base->set_isLvalue( false );
}

PointerType::PointerType( const Type::Qualifiers &tq, Type *base, Expression *dimension, bool isVarLen, bool isStatic )
	: Type( tq ), base( base ), dimension( dimension ), isVarLen( isVarLen ), isStatic( isStatic ) {
	base->set_isLvalue( false );
}

PointerType::PointerType( const PointerType &other )
	: Type( other ), base( maybeClone( other.base ) ), dimension( maybeClone( other.dimension ) ),
	  isVarLen( other.isVarLen ), isStatic( other.isStatic ) {
}

PointerType::~PointerType() {
	delete base;
	delete dimension;
}

void PointerType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << "pointer to ";
	if ( isStatic ) {
		os << "static ";
	} // if
	if ( isVarLen ) {
		os << "variable length array of ";
	} else if ( dimension ) {
		os << "array of ";
		dimension->print( os, indent );
	} // if
	if ( base ) {
		base->print( os, indent );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
