//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ObjectDecl.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 10:14:18 2015
// Update Count     : 2
//

#include "Declaration.h"
#include "Type.h"
#include "Initializer.h"
#include "Expression.h"
#include "utility.h"

ObjectDecl::ObjectDecl( const std::string &name, StorageClass sc, LinkageSpec::Type linkage, Expression *bitfieldWidth, Type *type, Initializer *init )
	: Parent( name, sc, linkage ), type( type ), init( init ), bitfieldWidth( bitfieldWidth ) {
}

ObjectDecl::ObjectDecl( const ObjectDecl &other )
	: Parent( other ), type( maybeClone( other.type ) ), init( maybeClone( other.init ) ), bitfieldWidth( maybeClone( other.bitfieldWidth ) ) {
}

ObjectDecl::~ObjectDecl() {
	delete type;
	delete init;
	delete bitfieldWidth;
}

void ObjectDecl::print( std::ostream &os, int indent ) const {
	if ( get_name() != "" ) {
		os << get_name() << ": a ";
	} // if

	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << LinkageSpec::toString( get_linkage() ) << " ";
	} // if

	if ( get_storageClass() != NoStorageClass ) {
		os << storageClassName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( init ) {
		os << "with initializer ";
		init->print( os, indent );
	} // if

	if ( bitfieldWidth ) {
		os << "with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

void ObjectDecl::printShort( std::ostream &os, int indent ) const {
	if ( get_name() != "" ) {
		os << get_name() << ": a ";
	} // if

	if ( get_storageClass() != NoStorageClass ) {
		os << storageClassName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( bitfieldWidth ) {
		os << "with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
