//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mutator.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 10:12:28 2015
// Update Count     : 3
//
#include <cassert>

#include "SynTree.h"
#include "SemanticError.h"

#ifndef MUTATOR_H
#define MUTATOR_H

class Mutator {
  protected:
	Mutator();
	virtual ~Mutator();
  public:
	virtual ObjectDecl* mutate( ObjectDecl *objectDecl );
	virtual DeclarationWithType* mutate( FunctionDecl *functionDecl );
	virtual Declaration* mutate( StructDecl *aggregateDecl );
	virtual Declaration* mutate( UnionDecl *aggregateDecl );
	virtual Declaration* mutate( EnumDecl *aggregateDecl );
	virtual Declaration* mutate( ContextDecl *aggregateDecl );
	virtual TypeDecl* mutate( TypeDecl *typeDecl );
	virtual Declaration* mutate( TypedefDecl *typeDecl );

	virtual CompoundStmt* mutate( CompoundStmt *compoundStmt );
	virtual Statement* mutate( ExprStmt *exprStmt );
	virtual Statement* mutate( IfStmt *ifStmt );
	virtual Statement* mutate( WhileStmt *whileStmt );
	virtual Statement* mutate( ForStmt *forStmt );
	virtual Statement* mutate( SwitchStmt *switchStmt );
	virtual Statement* mutate( ChooseStmt *chooseStmt );
	virtual Statement* mutate( FallthruStmt *fallthruStmt );
	virtual Statement* mutate( CaseStmt *caseStmt );
	virtual Statement* mutate( BranchStmt *branchStmt );
	virtual Statement* mutate( ReturnStmt *returnStmt );
	virtual Statement* mutate( TryStmt *returnStmt );
	virtual Statement* mutate( CatchStmt *catchStmt );
	virtual Statement* mutate( FinallyStmt *catchStmt );
	virtual NullStmt* mutate( NullStmt *nullStmt );
	virtual Statement* mutate( DeclStmt *declStmt );

	virtual Expression* mutate( ApplicationExpr *applicationExpr );
	virtual Expression* mutate( UntypedExpr *untypedExpr );
	virtual Expression* mutate( NameExpr *nameExpr );
	virtual Expression* mutate( AddressExpr *castExpr );
	virtual Expression* mutate( LabelAddressExpr *labAddressExpr );
	virtual Expression* mutate( CastExpr *castExpr );
	virtual Expression* mutate( UntypedMemberExpr *memberExpr );
	virtual Expression* mutate( MemberExpr *memberExpr );
	virtual Expression* mutate( VariableExpr *variableExpr );
	virtual Expression* mutate( ConstantExpr *constantExpr ); 
	virtual Expression* mutate( SizeofExpr *sizeofExpr );
	virtual Expression* mutate( AttrExpr *attrExpr );
	virtual Expression* mutate( LogicalExpr *logicalExpr );
	virtual Expression* mutate( ConditionalExpr *conditionalExpr );
	virtual Expression* mutate( CommaExpr *commaExpr );
	virtual Expression* mutate( TupleExpr *tupleExpr );
	virtual Expression* mutate( SolvedTupleExpr *tupleExpr );
	virtual Expression* mutate( TypeExpr *typeExpr );
	virtual Expression* mutate( UntypedValofExpr *valofExpr );

	virtual Type* mutate( VoidType *basicType );
	virtual Type* mutate( BasicType *basicType );
	virtual Type* mutate( PointerType *pointerType );
	virtual Type* mutate( ArrayType *arrayType );
	virtual Type* mutate( FunctionType *functionType );
	virtual Type* mutate( StructInstType *aggregateUseType );
	virtual Type* mutate( UnionInstType *aggregateUseType );
	virtual Type* mutate( EnumInstType *aggregateUseType );
	virtual Type* mutate( ContextInstType *aggregateUseType );
	virtual Type* mutate( TypeInstType *aggregateUseType );
	virtual Type* mutate( TupleType *tupleType );
	virtual Type* mutate( TypeofType *typeofType );
	virtual Type* mutate( AttrType *attrType );

	virtual Initializer* mutate( SingleInit *singleInit );
	virtual Initializer* mutate( ListInit *listInit );

	virtual Subrange *mutate( Subrange *subrange );

	virtual Constant *mutate( Constant *constant );
  private:
	virtual Declaration* handleAggregateDecl(AggregateDecl *aggregateDecl );
	virtual Declaration* handleNamedTypeDecl(NamedTypeDecl *typeDecl );
	virtual Type* handleReferenceToType(ReferenceToType *aggregateUseType );
};

template< typename TreeType, typename MutatorType >
inline TreeType *maybeMutate( TreeType *tree, MutatorType &mutator ) {
	if ( tree ) {
		TreeType *newnode = dynamic_cast< TreeType* >( tree->acceptMutator( mutator ) );
		assert( newnode );
		return newnode;
///	    return tree->acceptMutator( mutator );
	} else {
		return 0;
	} // if
}

template< typename Container, typename MutatorType >
inline void mutateAll( Container &container, MutatorType &mutator ) {
	SemanticError errors;
	for ( typename Container::iterator i = container.begin(); i != container.end(); ++i ) {
		try {
			if ( *i ) {
///		    *i = (*i)->acceptMutator( mutator );
				*i = dynamic_cast< typename Container::value_type >( (*i)->acceptMutator( mutator ) );
				assert( *i );
			} // if
		} catch( SemanticError &e ) {
			errors.append( e );
		} // try
	} // for
	if ( ! errors.isEmpty() ) {
		throw errors;
	} // if
}

#endif // MUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
