//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// XXX.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 07:53:48 2015
// Update Count     : 1
//

#include "Type.h"
#include "Expression.h"
#include "utility.h"


AttrType::AttrType( const Type::Qualifiers &tq, const std::string &name, Expression *expr )
	: Type( tq ), name( name ), expr( expr ), type( 0 ), isType( false ) {
}

AttrType::AttrType( const Type::Qualifiers &tq, const std::string &name, Type *type )
	: Type( tq ), name( name ), expr( 0 ), type( type ), isType( true ) {
}

AttrType::AttrType( const AttrType &other )
	: Type( other ), name( other.name ), expr( maybeClone( other.expr ) ), type( maybeClone( other.type ) ), isType( other.isType ) {
}

AttrType::~AttrType() {
	delete expr;
	delete type;
}

void AttrType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << "attribute " << name << " applied to ";
	if ( expr ) {
		os << "expression ";
		expr->print( os, indent );
	} // if
	if ( type ) {
		os << "type ";
		type->print( os, indent );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
