//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AddressExpr.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 23:54:44 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 07:48:14 2015
// Update Count     : 5
//

#include "Expression.h"
#include "Type.h"
#include "utility.h"

AddressExpr::AddressExpr( Expression *arg, Expression *_aname ) : Expression( _aname ), arg( arg ) {
    for ( std::list< Type* >::const_iterator i = arg->get_results().begin(); i != arg->get_results().end(); ++i ) {
		get_results().push_back( new PointerType( Type::Qualifiers(), (*i)->clone() ) );
    } // for
}

AddressExpr::AddressExpr( const AddressExpr &other ) : Expression( other ), arg( maybeClone( other.arg ) ) {
}

AddressExpr::~AddressExpr() {
    delete arg;
}

void AddressExpr::print( std::ostream &os, int indent ) const {
    os << std::string( indent, ' ' ) << "Address of:" << std::endl;
    if ( arg ) {
		arg->print( os, indent+2 );
    } // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
